// DriverSettings1.cpp : implementation file
//

#include "stdafx.h"
#include "DTC_C++Demo.h"
#include "MainSheet.h"
#include "PrinterSettings.h"
#include "DriverSettings1.h"
#include "DriverSettings2.h"
#include "afxdialogex.h"

//#############################################################################

// CDriverSettings1 dialog
IMPLEMENT_DYNAMIC(CDriverSettings1, CPropertyPage)

CDriverSettings1::CDriverSettings1()
	: CPropertyPage(CDriverSettings1::IDD)
	, DvrAction(0), ResolutionRadio(0)
{
	Initialised = FALSE;
}

CDriverSettings1::~CDriverSettings1()
{
}

void CDriverSettings1::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_DRIVERBOX, Driver1Msg);
	DDX_Radio(pDX, IDC_GETACTIONRADIO_D1, DvrAction);
	DDV_MinMaxInt(pDX, DvrAction, 0, 1);
	DDX_Control(pDX, IDC_COLOURCORRECTION_COMBO, ColourCorrection);
	DDX_Control(pDX, IDC_PRINTSPEED_COMBO, PrintSpeed);
	DDX_Control(pDX, IDC_SHARPNESS, Sharpness);
	DDX_Control(pDX, IDC_SHARPNESS_SPIN, Sharpness_Spin);
	DDX_Control(pDX, IDC_YMC_POWER, YMCPower);
	DDX_Control(pDX, IDC_YMC_POWER_SPIN, YMCPower_Spin);
	DDX_Control(pDX, IDC_K_POWER, KPower);
	DDX_Control(pDX, IDC_K_POWER_SPIN, KPower_Spin);
	DDX_Control(pDX, IDC_O_POWER, OPower);
	DDX_Control(pDX, IDC_O_POWER_SPIN, OPower_Spin);
	DDX_Control(pDX, IDC_RESINAREA_NO, ResinArea_No);
	DDX_Control(pDX, IDC_RESINAREA_NO_SPIN, ResinArea_No_Spin);
	DDX_Control(pDX, IDC_RESINAREA_SIDE, ResinArea_Side);
	DDX_Control(pDX, IDC_RESINAREA_LEFT, ResinArea_Left);
	DDX_Control(pDX, IDC_RESINAREA_LEFT_SPIN, ResinArea_Left_Spin);
	DDX_Control(pDX, IDC_RESINAREA_WIDTH, ResinArea_Width);
	DDX_Control(pDX, IDC_RESINAREA_WIDTH_SPIN, ResinArea_Width_Spin);
	DDX_Control(pDX, IDC_RESINAREA_BOTTOM, ResinArea_Bottom);
	DDX_Control(pDX, IDC_RESINAREA_BOTTOM_SPIN, ResinArea_Bottom_Spin);
	DDX_Control(pDX, IDC_RESINAREA_HEIGHT, ResinArea_Height);
	DDX_Control(pDX, IDC_RESINAREA_HEIGHT_SPIN, ResinArea_Height_Spin);
	DDX_Control(pDX, IDC_AREAHOLE_NO, AreaHole_No);
	DDX_Control(pDX, IDC_AREAHOLE_NO_SPIN, AreaHole_No_Spin);
	DDX_Control(pDX, IDC_AREAHOLE_SIDE, AreaHole_Side);
	DDX_Control(pDX, IDC_AREAHOLE_TYPE, AreaHole_Type);
	DDX_Control(pDX, IDC_AREAHOLE_LEFT, AreaHole_Left);
	DDX_Control(pDX, IDC_AREAHOLE_LEFT_SPIN, AreaHole_Left_Spin);
	DDX_Control(pDX, IDC_AREAHOLE_WIDTH, AreaHole_Width);
	DDX_Control(pDX, IDC_AREAHOLE_WIDTH_SPIN, AreaHole_Width_Spin);
	DDX_Control(pDX, IDC_AREAHOLE_BOTTOM, AreaHole_Bottom);
	DDX_Control(pDX, IDC_AREAHOLE_BOTTOM_SPIN, AreaHole_Bottom_Spin);
	DDX_Control(pDX, IDC_AREAHOLE_HEIGHT, AreaHole_Height);
	DDX_Control(pDX, IDC_AREAHOLE_HEIGHT_SPIN, AreaHole_Height_Spin);
	DDX_Control(pDX, IDC_ERASEAREA_LEFT, EraseArea_Left);
	DDX_Control(pDX, IDC_ERASEAREA_LEFT_SPIN, EraseArea_Left_Spin);
	DDX_Control(pDX, IDC_ERASEAREA_WIDTH, EraseArea_Width);
	DDX_Control(pDX, IDC_ERASEAREA_WIDTH_SPIN, EraseArea_Width_Spin);
	DDX_Control(pDX, IDC_ERASEAREA_BOTTOM, EraseArea_Bottom);
	DDX_Control(pDX, IDC_ERASEAREA_BOTTOM_SPIN, EraseArea_Bottom_Spin);
	DDX_Control(pDX, IDC_ERASEAREA_HEIGHT, EraseArea_Height);
	DDX_Control(pDX, IDC_ERASEAREA_HEIGHT_SPIN, EraseArea_Height_Spin);
	DDX_Control(pDX, IDC_ERASEPOWER_START, ErasePower_Start);
	DDX_Control(pDX, IDC_ERASEPOWER_START_SPIN, ErasePower_Start_Spin);
	DDX_Control(pDX, IDC_ERASEPOWER_END, ErasePower_End);
	DDX_Control(pDX, IDC_ERASEPOWER_END_SPIN, ErasePower_End_Spin);
	DDX_Control(pDX, IDC_ERASEPOWER_WRITE, WritePower);
	DDX_Control(pDX, IDC_ERASEPOWER_WRITE_SPIN, WritePower_Spin);
	DDX_Control(pDX, IDC_ERASEBEFOREPRINT, EraseBeforePrint);
	DDX_Control(pDX, IDC_GUIUSER, GUIUser);
	DDX_Control(pDX, IDC_GUIPRINTER, GUIPrinter);
	DDX_Control(pDX, IDC_BTN_PRINTSPEED, PrintSpeedBtn);
	DDX_Control(pDX, IDC_PRINTABLEAREA_LEFT, PrintableArea_Left);
	DDX_Control(pDX, IDC_PRINTABLEAREA_WIDTH, PrintableArea_Width);
	DDX_Control(pDX, IDC_PRINTABLEAREA_BOTTOM, PrintableArea_Bottom);
	DDX_Control(pDX, IDC_PRINTABLEAREA_HEIGHT, PrintableArea_Height);
	DDX_Control(pDX, IDC_PRINTABLEAREA_LEFT_SPIN, PrintableArea_Left_Spin);
	DDX_Control(pDX, IDC_PRINTABLEAREA_WIDTH_SPIN, PrintableArea_Width_Spin);
	DDX_Control(pDX, IDC_PRINTABLEAREA_BOTTOM_SPIN, PrintableArea_Bottom_Spin);
	DDX_Control(pDX, IDC_PRINTABLEAREA_HEIGHT_SPIN, PrintableArea_Height_Spin);
	DDX_Control(pDX, IDC_ERASEPOWEREND_LABEL, ErasePowerEndLabel);
	DDX_Control(pDX, IDC_WRITEPOWERLABEL, WritePowerLabel);
	DDX_Control(pDX, IDC_BTN_PRINTABLEAREA, PrintableAreaBtn);
	DDX_Control(pDX, IDC_BTN_SETDPI, ResolutionBtn);
	DDX_Radio(pDX, IDC_RADIO300DPI, ResolutionRadio);
}

BEGIN_MESSAGE_MAP(CDriverSettings1, CPropertyPage)
	ON_BN_CLICKED(IDC_BTN_DRIVERBOXCLEAR, &CDriverSettings1::OnBnClickedBtnDriverboxclear)
	ON_BN_CLICKED(IDC_BTN_GUICONTROL, &CDriverSettings1::OnBnClickedBtnGUIcontrol)
	ON_BN_CLICKED(IDC_BTN_SHARPNESS, &CDriverSettings1::OnBnClickedBtnSharpness)
	ON_BN_CLICKED(IDC_BTN_COLOURCORRECTION, &CDriverSettings1::OnBnClickedBtnColourcorrection)
	ON_BN_CLICKED(IDC_BTN_PRINTSPEED, &CDriverSettings1::OnBnClickedBtnPrintspeed)
	ON_BN_CLICKED(IDC_BTN_POWERLEVEL, &CDriverSettings1::OnBnClickedBtnPowerlevel)
	ON_BN_CLICKED(IDC_BTN_RESINAREA, &CDriverSettings1::OnBnClickedBtnResinarea)
	ON_BN_CLICKED(IDC_BTN_AREAHOLE, &CDriverSettings1::OnBnClickedBtnAreahole)
	ON_BN_CLICKED(IDC_BTN_REWRITABLE, &CDriverSettings1::OnBnClickedBtnRewritable)
	ON_BN_CLICKED(IDC_SETACTIONRADIO_D1, &CDriverSettings1::OnBnClickedSetActionRadio)
	ON_BN_CLICKED(IDC_GETACTIONRADIO_D1, &CDriverSettings1::OnBnClickedGetActionRadio)
	ON_CBN_SELCHANGE(IDC_RESINAREA_SIDE, &CDriverSettings1::OnCbnSelchangeResinArea)
	ON_CBN_SELCHANGE(IDC_AREAHOLE_SIDE, &CDriverSettings1::OnCbnSelchangeAreaHole)
	ON_CBN_SELCHANGE(IDC_AREAHOLE_TYPE, &CDriverSettings1::OnCbnSelchangeAreaHole)
	ON_EN_CHANGE(IDC_AREAHOLE_NO, &CDriverSettings1::OnEnChangeAreaholeNo)
	ON_EN_CHANGE(IDC_RESINAREA_NO, &CDriverSettings1::OnEnChangeResinareaNo)
	ON_BN_CLICKED(IDC_BTN_PRINTABLEAREA, &CDriverSettings1::OnBnClickedPrintablearea)
	ON_BN_CLICKED(IDC_BTN_SETDPI, &CDriverSettings1::OnBnClickedBtnResolution)
END_MESSAGE_MAP()

//#############################################################################

// CDriverSettings1 message handlers
BOOL CDriverSettings1::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	Parent = (CMainSheet *)GetParent();

	//Initialise the Controls on the Property Page...
	//...GUIControl
	ID_GUICONTROL GUICtrl;
	GetGUIControl(&GUICtrl);
	SetGUIControl(&GUICtrl);

	//...Sharpness
	signed char temp;
	Sharpness_Spin.SetRange(-2, +2);
	GetSharpness(&temp);

	//...Colour Correction
	COLCORRECT ColCorrect;
	GetColourCorrection(&ColCorrect);

	//...Print Speed
	if (Parent->PrinterType == ID_ENDURO)
	{
		PrintSpeedBtn.ShowWindow(TRUE);
		PrintSpeed.ShowWindow(TRUE);
		ID_PRINTSPEED PrintSpeed;
		GetPrintSpeed(&PrintSpeed);
	}
	else
	{
		PrintSpeedBtn.ShowWindow(FALSE);
		PrintSpeed.ShowWindow(FALSE);
	}

	//...Power Level
	POWERLEVEL PowerLevel;
	if(Parent->PrinterType == ID_GENERATION2)
	{
		YMCPower_Spin.SetRange(-100, 100);
		KPower_Spin.SetRange(-100, 100);
		OPower_Spin.SetRange(-100, 100);
	}
	else
	{
		YMCPower_Spin.SetRange(0, 100);
		KPower_Spin.SetRange(0, 100);
		OPower_Spin.SetRange(0, 100);
	}
	GetPowerLevels(&PowerLevel);

	//...Resin Area
	AREA Area;
	ResinArea_Side.SetCurSel(0);
	ResinArea_No.SetWindowText(_T("1"));
	ResinArea_No_Spin.SetRange(1, 5);
	ResinArea_Left_Spin.SetRange(0, Parent->MaxXCoord());
	ResinArea_Width_Spin.SetRange(0, Parent->MaxCardWidth());
	ResinArea_Bottom_Spin.SetRange(0, Parent->MaxYCoord());
	ResinArea_Height_Spin.SetRange(0, Parent->MaxCardHeight());
	GetResinArea(ID_SIDE_FRONT, 1, &Area);

	//...AreaHole(s)
	AreaHole_Side.SetCurSel(0);
	AreaHole_Type.SetCurSel(0);
	AreaHole_No_Spin.SetRange(1, 2);
	AreaHole_Left_Spin.SetRange(0, Parent->MaxXCoord());
	AreaHole_Width_Spin.SetRange(0, Parent->MaxCardWidth());
	AreaHole_Bottom_Spin.SetRange(0, Parent->MaxYCoord());
	AreaHole_Height_Spin.SetRange(0, Parent->MaxCardHeight());
	AreaHole_No.SetWindowText(_T("1"));
	GetAreaHole(ID_SIDE_FRONT, ID_AREA, 1, &Area);

	//...Rewritable
	REWRITABLE Rewritable;
	EraseArea_Left_Spin.SetRange(0, Parent->MaxXCoord());
	EraseArea_Width_Spin.SetRange(0, Parent->MaxCardWidth());
	EraseArea_Bottom_Spin.SetRange(0, Parent->MaxYCoord());
	EraseArea_Height_Spin.SetRange(0, Parent->MaxCardHeight());
	ErasePower_Start_Spin.SetRange(1, 99);
	ErasePower_End_Spin.SetRange(1, 99);
	WritePower_Spin.SetRange(1, 99);
	GetRewritable(&Rewritable);
	
	if(Parent->PrinterType == ID_GENERATION2)
	{
		ErasePowerEndLabel.ShowWindow(FALSE);
		ErasePower_End.ShowWindow(FALSE);
		ErasePower_End_Spin.ShowWindow(FALSE);
		WritePowerLabel.ShowWindow(FALSE);
		WritePower.ShowWindow(FALSE);
		WritePower_Spin.ShowWindow(FALSE);

		//...Printable Area
		PrintableArea_Left_Spin.SetRange(0, Parent->MaxXCoord());
		PrintableArea_Width_Spin.SetRange(0, Parent->MaxCardWidth());
		PrintableArea_Bottom_Spin.SetRange(0, Parent->MaxYCoord());
		PrintableArea_Height_Spin.SetRange(0, Parent->MaxCardHeight());
		GetPrintableArea(&Area);
	}
	else
	{
		PrintableAreaBtn.EnableWindow(FALSE);
	}

	EnableGetSetControls(FALSE);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

//****************************************************************************

BOOL CDriverSettings1::OnSetActive()
{
	CPropertyPage::OnSetActive();

	if (PrinterIs600DPICapable())
	{
		BYTE resolution;
		GetResolution(&resolution);
		ResolutionBtn.EnableWindow(true);
	}

	return TRUE;
}

//****************************************************************************

BOOL CDriverSettings1::PrinterIs600DPICapable()
{
	if (Parent->PrinterType != ID_GENERATION2)
	{
		return FALSE;
	}

	return ((Parent->PrinterModel & ID_FN_600DPI) != 0);
}

//****************************************************************************

void CDriverSettings1::EnableGetSetControls
(
	BOOL bControl
)
{
	if (Parent->PrinterType == ID_ENDURO)
	{
		PrintSpeed.EnableWindow(bControl);
	}

	if (Parent->PrinterType == ID_GENERATION2)
	{
		PrintableArea_Left.EnableWindow(bControl);
		PrintableArea_Width.EnableWindow(bControl);
		PrintableArea_Bottom.EnableWindow(bControl);
		PrintableArea_Height.EnableWindow(bControl);
		PrintableArea_Left_Spin.EnableWindow(bControl);
		PrintableArea_Width_Spin.EnableWindow(bControl);
		PrintableArea_Bottom_Spin.EnableWindow(bControl);
		PrintableArea_Height_Spin.EnableWindow(bControl);

		if (PrinterIs600DPICapable())
		{
			GetDlgItem(IDC_RADIO300DPI)->EnableWindow(bControl);
			GetDlgItem(IDC_RADIO600DPI)->EnableWindow(bControl);
		}
	}

	GUIUser.EnableWindow(bControl);
	GUIPrinter.EnableWindow(bControl);
	Sharpness.EnableWindow(bControl);
	Sharpness_Spin.EnableWindow(bControl);
	ColourCorrection.EnableWindow(bControl);

	YMCPower.EnableWindow(bControl);
	KPower.EnableWindow(bControl);
	OPower.EnableWindow(bControl);
	YMCPower_Spin.EnableWindow(bControl);
	KPower_Spin.EnableWindow(bControl);
	OPower_Spin.EnableWindow(bControl);

	ResinArea_Left.EnableWindow(bControl);
	ResinArea_Width.EnableWindow(bControl);
	ResinArea_Bottom.EnableWindow(bControl);
	ResinArea_Height.EnableWindow(bControl);
	ResinArea_Left_Spin.EnableWindow(bControl);
	ResinArea_Width_Spin.EnableWindow(bControl);
	ResinArea_Bottom_Spin.EnableWindow(bControl);
	ResinArea_Height_Spin.EnableWindow(bControl);

	AreaHole_Left.EnableWindow(bControl);
	AreaHole_Width.EnableWindow(bControl);
	AreaHole_Bottom.EnableWindow(bControl);
	AreaHole_Height.EnableWindow(bControl);
	AreaHole_Left_Spin.EnableWindow(bControl);
	AreaHole_Width_Spin.EnableWindow(bControl);
	AreaHole_Bottom_Spin.EnableWindow(bControl);
	AreaHole_Height_Spin.EnableWindow(bControl);

	EraseArea_Left.EnableWindow(bControl);
	EraseArea_Width.EnableWindow(bControl);
	EraseArea_Bottom.EnableWindow(bControl);
	EraseArea_Height.EnableWindow(bControl);
	ErasePower_Start.EnableWindow(bControl);
	ErasePower_End.EnableWindow(bControl);
	WritePower.EnableWindow(bControl);
	EraseArea_Left_Spin.EnableWindow(bControl);
	EraseArea_Width_Spin.EnableWindow(bControl);
	EraseArea_Bottom_Spin.EnableWindow(bControl);
	EraseArea_Height_Spin.EnableWindow(bControl);
	ErasePower_Start_Spin.EnableWindow(bControl);
	ErasePower_End_Spin.EnableWindow(bControl);
	WritePower_Spin.EnableWindow(bControl);
	EraseBeforePrint.EnableWindow(bControl);
}

void CDriverSettings1::OnBnClickedGetActionRadio()
{
	EnableGetSetControls(FALSE);
}

void CDriverSettings1::OnBnClickedSetActionRadio()
{
	EnableGetSetControls(TRUE);
}

void CDriverSettings1::OnBnClickedBtnDriverboxclear()
{
	Driver1Msg.SetWindowText(_T(""));
}

BOOL CDriverSettings1::ActionIsGet()
{
	UpdateData();
	return (DvrAction == 0);
}

int CDriverSettings1::GetResolutionRadio()
{
	UpdateData(TRUE);
	return ResolutionRadio;
}

void CDriverSettings1::AddDriverMessage
(
	CString pMessage
)
{
	Parent->AddString(&Driver1Msg, pMessage);
}

//#############################################################################

void CDriverSettings1::GUIControlToMsgBox
(
	PID_GUICONTROL pControl,
	ID_READWRITE   Action
)
{
	//Update the message box with GUI control status
	CString sep = Parent->Separator(Action);
	AddDriverMessage(_T("GUI User")    + sep + Parent->EnabledDisabledString(pControl->GUIUser));
	AddDriverMessage(_T("GUI Printer") + sep + Parent->EnabledDisabledString(pControl->GUIPrinter));
	AddDriverMessage(_T(""));
}

//****************************************************************************

void CDriverSettings1::SetGUIControl
(
	PID_GUICONTROL pControl
)
{
	//Update the GUI control display objects
	GUIUser.SetCheck(pControl->GUIUser);
	GUIPrinter.SetCheck(pControl->GUIPrinter);
}

//****************************************************************************

ID_RETURN CDriverSettings1::GetGUIControl
(
	PID_GUICONTROL pControl
)
{
	ID_RETURN result = ID_ERROR;

	//Get SDK function address
	PFNIDGUICONTROL pFnGUIControl = (PFNIDGUICONTROL)GetProcAddress(Parent->hLib, "ID_GUIControl");
	if (!pFnGUIControl)
	{
		FUNCTION_NOT_ACCESSED(GetGUIControl);
	}

	else
	{
		//Call SDK to read the GUI User setting
		ID_RETURN SDKReturn = (*pFnGUIControl)(Parent->hSession, ID_READ, pControl);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(GetGUIControl, SDKReturn);
		}
		else
		{
			result = ID_SUCCESS;
		}
	}

	return result;
}

//****************************************************************************

void CDriverSettings1::OnBnClickedBtnGUIcontrol()
{
	CWaitCursor wait;
	ID_GUICONTROL Control;

	if (ActionIsGet())
	{
		//Get GUI control Setting
		if (GetGUIControl(&Control) == ID_SUCCESS)
		{
			//Update the display
			SetGUIControl(&Control);
			GUIControlToMsgBox(&Control, ID_READ);
		}
	}

	else
	{
		//Get SDK function address
		PFNIDGUICONTROL pFnSetGUIControl = (PFNIDGUICONTROL)GetProcAddress(Parent->hLib, "ID_GUIControl");
		if (!pFnSetGUIControl)
		{
			FUNCTION_NOT_ACCESSED(SetGUIControl);
		}

		else
		{
			//Get GUI Control setting from control
			Control.GUIUser    = GUIUser.GetCheck();
			Control.GUIPrinter = GUIPrinter.GetCheck();

			//Call the SDK to write to the driver
			ID_RETURN SDKReturn = (*pFnSetGUIControl)(Parent->hSession, ID_WRITE, &Control);
			if (SDKReturn != ERROR_SUCCESS)
			{
				DISPLAY_ERROR(SetGUIControl, SDKReturn);
			}

			else
			{
				//Update the message box
				GUIControlToMsgBox(&Control, ID_WRITE);
			}
		}
	}
}

//#############################################################################

void CDriverSettings1::SetSharpness(int value)
{
	//Update the Sharpness control
	CString temp_string;
	temp_string.Format(_T("%d"), value);
	Sharpness.SetWindowText(temp_string);
}

//****************************************************************************

void CDriverSettings1::SharpnessToMsgBox
(
	signed char  Sharpness,
	ID_READWRITE Action
)
{
	//Update the messagebox with the Sharpness setting
	CString temp_string;
	temp_string.Format(_T("%d"), Sharpness);
	AddDriverMessage(_T("Sharpness") + Parent->Separator(Action) + temp_string);
	AddDriverMessage(_T(""));
}

//****************************************************************************

ID_RETURN CDriverSettings1::GetSharpness
(
	signed char *pSharpness
)
{
	ID_RETURN SDKReturn = ID_ERROR;

	//Get SDK function address
	PFNIDSHARPNESS pFnSharpness = (PFNIDSHARPNESS)GetProcAddress(Parent->hLib, "ID_Sharpness");
	if (!pFnSharpness)
	{
		FUNCTION_NOT_ACCESSED(GetSharpness);
	}

	else
	{
		//Call SDK to read the Sharpness setting
		SDKReturn = (*pFnSharpness)(Parent->hSession, ID_READ, pSharpness);
		if (SDKReturn == ID_SUCCESS)
		{
			SetSharpness(*pSharpness);
		}
		else
		{
			DISPLAY_ERROR(GetSharpness, SDKReturn);
		}
	}

	return SDKReturn;
}

//****************************************************************************

void CDriverSettings1::OnBnClickedBtnSharpness()
{
	CWaitCursor wait;
	CString temp_string;
	signed char value;

	if (ActionIsGet())
	{
		//Get Sharpness Setting
		if (GetSharpness(&value) == ID_SUCCESS)
		{
			//Update the display
			SharpnessToMsgBox(value, ID_READ);
		}
	}

	else
	{
		//Get SDK function address
		PFNIDSHARPNESS pFnSetSharpness = (PFNIDSHARPNESS)GetProcAddress(Parent->hLib, "ID_Sharpness");
		if (!pFnSetSharpness)
		{
			FUNCTION_NOT_ACCESSED(Sharpness);
		}

		else
		{
			//Get Sharpness setting from control
			Sharpness.GetWindowText(temp_string);
			value = _ttoi(temp_string);

			//Call the SDK to update the driver
			ID_RETURN SDKReturn = (*pFnSetSharpness)(Parent->hSession, ID_WRITE, &value);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(SetSharpness, SDKReturn);
			}

			else
			{
				//Update the message box
				SharpnessToMsgBox(value, ID_WRITE);
			}
		}
	}
}

//#############################################################################

void CDriverSettings1::CorrectionToMsgBox
(
	COLCORRECT  Correction,
	ID_READWRITE Action
)
{
	//Update the message box with Colour Correction status
	AddDriverMessage(_T("Correction") + Parent->Separator(Action) + Parent->CorrectionString(Correction));
	AddDriverMessage(_T(""));
}

//****************************************************************************

void CDriverSettings1::SetColourCorrection
(
	COLCORRECT Correction
)
{
	//Update the Colour Correction display
	ColourCorrection.SetCurSel(Correction);
}

//****************************************************************************

ID_RETURN CDriverSettings1::GetColourCorrection
(
	PCOLCORRECT pCorrection
)
{
	ID_RETURN SDKReturn = ID_ERROR;

	//Get SDK function address
	PFNIDCORRECTION pFnColourCorrection = (PFNIDCORRECTION)GetProcAddress(Parent->hLib, "ID_ColourCorrection");
	if (!pFnColourCorrection)
	{
		FUNCTION_NOT_ACCESSED(GetColourCorrection);
	}

	else
	{
		//Call SDK to read the Colour Correction setting
		SDKReturn = (*pFnColourCorrection)(Parent->hSession, ID_READ, pCorrection);
		if (SDKReturn == ID_SUCCESS)
		{
			SetColourCorrection(*pCorrection);
		}
		else
		{
			DISPLAY_ERROR(GetColourCorrection, SDKReturn);
		}
	}

	return SDKReturn;
}

//****************************************************************************

void CDriverSettings1::OnBnClickedBtnColourcorrection()
{
	CWaitCursor	wait;
	COLCORRECT	Correction;

	if (ActionIsGet())
	{
		//Get Colour Correction Setting
		if (GetColourCorrection(&Correction) == ID_SUCCESS)
		{
			//Update the display
			CorrectionToMsgBox(Correction, ID_READ);
		}
	}

	else
	{
		//Get SDK function address
		PFNIDCORRECTION pFnSetColourCorrection = (PFNIDCORRECTION)GetProcAddress(Parent->hLib, "ID_ColourCorrection");
		if (!pFnSetColourCorrection)
		{
			FUNCTION_NOT_ACCESSED(SetColourCorrection);
		}

		else
		{
			//Get Colour Correction setting from control
			Correction = (COLCORRECT)ColourCorrection.GetCurSel();

			//Call the SDK to update it in the driver
			int SDKReturn = (*pFnSetColourCorrection)(Parent->hSession, ID_WRITE, &Correction);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(SetColourCorrection, SDKReturn);
			}

			else
			{
				//Update the message box
				CorrectionToMsgBox(Correction, ID_WRITE);
			}
		}
	}
}

//#############################################################################

CString CDriverSettings1::PrintSpeedString
(
	ID_PRINTSPEED PrintSpeed
)
{
	//Return the string corresponding to the given Print Speed value
	switch (PrintSpeed)
	{
	case ID_HIGHSPEED:   return _T("High");
	case ID_NORMALSPEED: return _T("Normal");
	default:             return _T("**Undefined**");
	}
}

//****************************************************************************

void CDriverSettings1::PrintSpeedToMsgBox
(
	ID_PRINTSPEED Speed,
	ID_READWRITE Action
)
{
	//Update the message box with the Print Speed setting
	AddDriverMessage(_T("Print Speed") + Parent->Separator(Action) + PrintSpeedString(Speed));
	AddDriverMessage(_T(""));
}

//****************************************************************************

void CDriverSettings1::SetPrintSpeed
(
	ID_PRINTSPEED Speed
)
{
	//Update the Print Speed control
	PrintSpeed.SetCurSel(Speed);
}

//****************************************************************************

ID_RETURN CDriverSettings1::GetPrintSpeed
(
	PID_PRINTSPEED pPrintSpeed
)
{
	ID_RETURN SDKReturn = ID_ERROR;

	//Get SDK function address
	PFNIDPRINTSPEED pFnPrintSpeed = (PFNIDPRINTSPEED)GetProcAddress(Parent->hLib, "ID_PrintSpeed");
	if (!pFnPrintSpeed)
	{
		FUNCTION_NOT_ACCESSED(GetPrintSpeed);
	}

	else
	{
		//Call SDK to read the Print Speed setting
		SDKReturn = (*pFnPrintSpeed)(Parent->hSession, ID_READ, pPrintSpeed);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(GetPrintSpeed, SDKReturn);
		}
		else
		{
			SetPrintSpeed(*pPrintSpeed);
		}
	}

	return SDKReturn;
}

//****************************************************************************

void CDriverSettings1::OnBnClickedBtnPrintspeed()
{
	CWaitCursor	wait;
	ID_PRINTSPEED speed;

	if (ActionIsGet())
	{
		//Get Print Speed Setting
		if (GetPrintSpeed(&speed) == ID_SUCCESS)
		{
			//Update the display
			PrintSpeedToMsgBox(speed, ID_READ);
		}
	}

	else
	{
		//Get SDK function address
		PFNIDPRINTSPEED pFnSetPrintSpeed = (PFNIDPRINTSPEED)GetProcAddress(Parent->hLib, "ID_PrintSpeed");
		if (!pFnSetPrintSpeed)
		{
			FUNCTION_NOT_ACCESSED(SetPrintSpeed);
		}

		else
		{
			//Get Print Speed setting from control
			speed = (ID_PRINTSPEED)PrintSpeed.GetCurSel();

			//Write to the driver
			ID_RETURN SDKReturn = (*pFnSetPrintSpeed)(Parent->hSession, ID_WRITE, &speed);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(SetPrintSpeed, SDKReturn);
			}

			else
			{
				//Update the message box
				PrintSpeedToMsgBox(speed, ID_WRITE);
			}
		}
	}
}

//#############################################################################

void CDriverSettings1::PowerLevelsToMsgBox
(
	POWERLEVEL PowerLevel,
	ID_READWRITE Action
)
{
	//Update the message box with the Power Levels
	CString temp_string;
	CString sep = Parent->Separator(Action);
	temp_string.Format(_T("%d"), (signed char)PowerLevel.YMC);
	AddDriverMessage(_T("Power Level YMC") + sep + temp_string);
	temp_string.Format(_T("%d"), (signed char)PowerLevel.Resin);
	AddDriverMessage(_T("Power Level Resin") + sep + temp_string);
	temp_string.Format(_T("%d"), (signed char)PowerLevel.Overcoat);
	AddDriverMessage(_T("Power Level Overcoat") + sep + temp_string);
	AddDriverMessage(_T(""));
}

//****************************************************************************

void CDriverSettings1::SetPowerLevels
(
	POWERLEVEL PowerLevel
)
{
	//Update the Power Levels controls
	CString temp_string;
	temp_string.Format(_T("%d"), (signed char)PowerLevel.YMC);
	YMCPower.SetWindowText(temp_string);
	temp_string.Format(_T("%d"), (signed char)PowerLevel.Resin);
	KPower.SetWindowText(temp_string);
	temp_string.Format(_T("%d"), (signed char)PowerLevel.Overcoat);
	OPower.SetWindowText(temp_string);
}

//****************************************************************************

ID_RETURN CDriverSettings1::GetPowerLevels
(
	PPOWERLEVEL pPowerLevel
)
{
	ID_RETURN SDKReturn = ID_ERROR;

	//Get SDK function address
	PFNIDPOWERLEVEL pFnPowerLevel = (PFNIDPOWERLEVEL)GetProcAddress(Parent->hLib, "ID_PowerLevel");
	if (!pFnPowerLevel)
	{
		FUNCTION_NOT_ACCESSED(GetPowerLevel);
	}

	else
	{
		//Call SDK to read the Power Level setting
		SDKReturn = (*pFnPowerLevel)(Parent->hSession, ID_READ, pPowerLevel);
		if (SDKReturn == ID_SUCCESS)
		{
			SetPowerLevels(*pPowerLevel);
		}
		else
		{
			DISPLAY_ERROR(GetPowerLevel, SDKReturn);
		}
	}

	return SDKReturn;
}

//****************************************************************************

void CDriverSettings1::OnBnClickedBtnPowerlevel()
{
	POWERLEVEL PowerLevel = {};
	CWaitCursor wait;
	CString temp_string;

	if (ActionIsGet())
	{
		//Get Power Level Settings
		if (GetPowerLevels(&PowerLevel) == ID_SUCCESS)
		{
			//Update the display
			PowerLevelsToMsgBox(PowerLevel, ID_READ);
		}
	}

	else
	{
		//Get SDK function address
		PFNIDPOWERLEVEL pFnSetPowerLevel = (PFNIDPOWERLEVEL)GetProcAddress(Parent->hLib, "ID_PowerLevel");
		if (!pFnSetPowerLevel)
		{
			FUNCTION_NOT_ACCESSED(SetPowerLevel);
		}

		else
		{
			//Get Power Level settings from controls
			YMCPower.GetWindowText(temp_string);
			PowerLevel.YMC = _ttoi(temp_string);
			KPower.GetWindowText(temp_string);
			PowerLevel.Resin = _ttoi(temp_string);
			OPower.GetWindowText(temp_string);
			PowerLevel.Overcoat = _ttoi(temp_string);

			//Write to the driver
			ID_RETURN SDKReturn = (*pFnSetPowerLevel)(Parent->hSession, ID_WRITE, &PowerLevel);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(SetPowerLevel, SDKReturn);
			}

			else
			{
				//Update the message box
				PowerLevelsToMsgBox(PowerLevel, ID_WRITE);
			}
		}
	}
}

//#############################################################################

void CDriverSettings1::OnCbnSelchangeResinArea()
{
	AREA Area = {0};
	CString temp_string;

	//Resin Area settings have been changed
	ResinArea_No.GetWindowText(temp_string);
	int AreaNo = _ttoi(temp_string);

	if (GetResinArea((ID_SIDE)ResinArea_Side.GetCurSel(), AreaNo, &Area) == ID_SUCCESS)
	{
		SetResinArea(&Area);
	}
}

//****************************************************************************

void CDriverSettings1::OnEnChangeResinareaNo()
{
	if (Initialised)
	{
		//Resin Area Number has been changed
		OnCbnSelchangeResinArea();
	}
}

//****************************************************************************

void CDriverSettings1::ResinAreaToMsgBox
(
	ID_SIDE      Side,
	int          AreaNo,
	PAREA        pArea,
	ID_READWRITE Action
)
{
	//Update the message box with the Resin Area settings
	CString temp_string;
	CString sep = Parent->Separator(Action);

	temp_string.Format(_T("Resin Area %s %d"), Parent->SideString(Side), AreaNo);
	AddDriverMessage(temp_string);
	temp_string.Format(_T("%d"), pArea->Left);
	AddDriverMessage(_T("Left") + sep + temp_string);
	temp_string.Format(_T("%d"), pArea->Width);
	AddDriverMessage(_T("Width") + sep + temp_string);
	temp_string.Format(_T("%d"), pArea->Bottom);
	AddDriverMessage(_T("Bottom") + sep + temp_string);
	temp_string.Format(_T("%d"), pArea->Height);
	AddDriverMessage(_T("Height") + sep + temp_string);
	AddDriverMessage(_T(""));
}

//****************************************************************************

void CDriverSettings1::SetResinArea(PAREA pArea)
{
	//Update the Resin Area controls
	CString temp_string;
	temp_string.Format(_T("%d"), pArea->Left);
	ResinArea_Left.SetWindowText(temp_string);
	temp_string.Format(_T("%d"), pArea->Width);
	ResinArea_Width.SetWindowText(temp_string);
	temp_string.Format(_T("%d"), pArea->Bottom);
	ResinArea_Bottom.SetWindowText(temp_string);
	temp_string.Format(_T("%d"), pArea->Height);
	ResinArea_Height.SetWindowText(temp_string);
}

//****************************************************************************

ID_RETURN CDriverSettings1::GetResinArea
(
	ID_SIDE Side,
	int		AreaNo,
	PAREA	pArea
)
{
	ID_RETURN SDKReturn = ID_ERROR;

	//Get SDK function address
	PFNIDRESINAREA pFnResinArea = (PFNIDRESINAREA)GetProcAddress(Parent->hLib, "ID_ResinArea");
	if (!pFnResinArea)
	{
		FUNCTION_NOT_ACCESSED(GetResinArea);
	}

	else
	{
		//Call SDK to read the Resin Area setting
		SDKReturn = (*pFnResinArea)(Parent->hSession, ID_READ, Side, AreaNo, pArea);
		if (SDKReturn == ID_SUCCESS)
		{
			SetResinArea(pArea);
		}
		else
		{
			DISPLAY_ERROR(GetResinArea, SDKReturn);
		}
	}

	return SDKReturn;
}

//****************************************************************************

void CDriverSettings1::OnBnClickedBtnResinarea()
{
	AREA Area = {0};
	CWaitCursor wait;
	CString temp_string;

	ResinArea_No.GetWindowText(temp_string);
	int AreaNo = _ttoi(temp_string);
	ID_SIDE Side = (ID_SIDE)ResinArea_Side.GetCurSel();

	if (ActionIsGet())
	{
		//Get the Resin Area settings
		if (GetResinArea(Side, AreaNo, &Area) == ID_SUCCESS)
		{
			//Update the display
			ResinAreaToMsgBox(Side, AreaNo, &Area, ID_READ);
		}
	}

	else
	{
		//Get SDK function address
		PFNIDRESINAREA pFnSetResinArea = (PFNIDRESINAREA)GetProcAddress(Parent->hLib, "ID_ResinArea");
		if (!pFnSetResinArea)
		{
			FUNCTION_NOT_ACCESSED(SetResinArea);
		}

		else
		{
			//Get the selected Resin Area settings
			ResinArea_Left.GetWindowText(temp_string);
			Area.Left = _ttoi(temp_string);
			ResinArea_Width.GetWindowText(temp_string);
			Area.Width = _ttoi(temp_string);
			ResinArea_Bottom.GetWindowText(temp_string);
			Area.Bottom = _ttoi(temp_string);
			ResinArea_Height.GetWindowText(temp_string);
			Area.Height = _ttoi(temp_string);

			//Call the SDK to write to the driver
			ID_RETURN SDKReturn = (*pFnSetResinArea)(Parent->hSession,
											         ID_WRITE,
											         Side,
											         AreaNo,
											         &Area);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(SetResinArea, SDKReturn);
			}

			else
			{
				//Update the message box
				ResinAreaToMsgBox(Side, AreaNo, &Area, ID_WRITE);
			}
		}
	}
}

//#############################################################################

void CDriverSettings1::OnCbnSelchangeAreaHole()
{
	AREA Area = {0};
	CString temp_string;

	//Area/Hole settings have been changed
	AreaHole_No.GetWindowText(temp_string);
	int AreaNo = _ttoi(temp_string);

	//Call SDK to read the Area/Hole setting
	if (GetAreaHole((ID_SIDE)AreaHole_Side.GetCurSel(),
					(ID_AREAHOLE)AreaHole_Type.GetCurSel(),
					AreaNo,
					&Area) == ID_SUCCESS)
	{
		//Update the display
		SetAreaHole(&Area);
	}
}

void CDriverSettings1::OnEnChangeAreaholeNo()
{
	if (Initialised)
	{
		//Area/Hole number has been changed
		OnCbnSelchangeAreaHole();
	}
}

//****************************************************************************

void CDriverSettings1::AreaHoleToMsgBox
(
	ID_SIDE      Side,
	ID_AREAHOLE	 Type,
	int          AreaNo,
	PAREA        pArea,
	ID_READWRITE Action
)
{
	//Update the message box for the Area/Hole settings
	CString temp_string;
	CString sep = Parent->Separator(Action);

	temp_string.Format(_T("AreaHole %s %s %d"),
					   Parent->SideString(Side),
					   Type == ID_HOLE ? _T("Hole") : _T("Area"),
					   AreaNo);
	AddDriverMessage(temp_string);
	temp_string.Format(_T("%d"), pArea->Left);
	AddDriverMessage(_T("Left") + sep + temp_string);
	temp_string.Format(_T("%d"), pArea->Width);
	AddDriverMessage(_T("Width") + sep + temp_string);
	temp_string.Format(_T("%d"), pArea->Bottom);
	AddDriverMessage(_T("Bottom") + sep + temp_string);
	temp_string.Format(_T("%d"), pArea->Height);
	AddDriverMessage(_T("Height") + sep + temp_string);
	AddDriverMessage(_T(""));
}

//****************************************************************************

void CDriverSettings1::SetAreaHole(PAREA pArea)
{
	//Update the display controls for the Area/Hole settings
	CString temp_string;
	temp_string.Format(_T("%d"), pArea->Left);
	AreaHole_Left.SetWindowText(temp_string);
	temp_string.Format(_T("%d"), pArea->Width);
	AreaHole_Width.SetWindowText(temp_string);
	temp_string.Format(_T("%d"), pArea->Bottom);
	AreaHole_Bottom.SetWindowText(temp_string);
	temp_string.Format(_T("%d"), pArea->Height);
	AreaHole_Height.SetWindowText(temp_string);
}

//****************************************************************************

ID_RETURN CDriverSettings1::GetAreaHole
(
	ID_SIDE		Side,
	ID_AREAHOLE	Type,
	int			AreaNo,
	PAREA		pArea
)
{
	ID_RETURN SDKReturn = ID_ERROR;

	//Get SDK function address
	PFNIDAREAHOLE pFnAreaHole = (PFNIDAREAHOLE)GetProcAddress(Parent->hLib, "ID_AreaHole");
	if (!pFnAreaHole)
	{
		FUNCTION_NOT_ACCESSED(GetAreaHole);
	}

	else
	{
		//Call SDK to read the Area/Hole setting
		SDKReturn = (*pFnAreaHole)(Parent->hSession, ID_READ, Side, Type, AreaNo, pArea);
		if (SDKReturn == ID_SUCCESS)
		{
			SetAreaHole(pArea);
		}
		else
		{
			DISPLAY_ERROR(GetAreaHole, SDKReturn);
		}
	}

	return SDKReturn;
}

//****************************************************************************

void CDriverSettings1::OnBnClickedBtnAreahole()
{
	CWaitCursor wait;
	CString temp_string;

	AREA        Area = {0};
	ID_SIDE     Side = (ID_SIDE)AreaHole_Side.GetCurSel();
	ID_AREAHOLE Type = (ID_AREAHOLE)AreaHole_Type.GetCurSel();

	AreaHole_No.GetWindowText(temp_string);
	int AreaNo = _ttoi(temp_string);

	if (ActionIsGet())
	{
		//Get the Area/Hole settings
		if (GetAreaHole(Side, Type, AreaNo, &Area) == ID_SUCCESS)
		{
			//Update the display
			AreaHoleToMsgBox(Side, Type, AreaNo, &Area, ID_READ);
		}
	}

	else
	{
		//Get SDK function address
		PFNIDAREAHOLE pFnSetAreaHole = (PFNIDAREAHOLE)GetProcAddress(Parent->hLib, "ID_AreaHole");
		if (!pFnSetAreaHole)
		{
			FUNCTION_NOT_ACCESSED(SetAreaHole);
		}

		else
		{
			//Get the Area/Hole selections
			AreaHole_Left.GetWindowText(temp_string);
			Area.Left = _ttoi(temp_string);
			AreaHole_Width.GetWindowText(temp_string);
			Area.Width = _ttoi(temp_string);
			AreaHole_Bottom.GetWindowText(temp_string);
			Area.Bottom = _ttoi(temp_string);
			AreaHole_Height.GetWindowText(temp_string);
			Area.Height = _ttoi(temp_string);

			//Call the SDK to write to the driver
			ID_RETURN SDKReturn = (*pFnSetAreaHole)(Parent->hSession,
											        ID_WRITE,
											        Side,
											        Type,
											        AreaNo,
											        &Area);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(SetAreaHole, SDKReturn);
			}
			else
			{
				//Update the message box
				AreaHoleToMsgBox(Side, Type, AreaNo, &Area, ID_WRITE);
			}
		}
	}
}

//#############################################################################

void CDriverSettings1::RewritableToMsgBox
(
	PREWRITABLE pRewritable,
	ID_READWRITE Action
)
{
	//Update the message box for the Rewritable Card settings
	CString temp_string;
	CString sep = Parent->Separator(Action);

	temp_string.Format(_T("%d, %d, %d, %d"),
					   pRewritable->EraseArea.Left,
					   pRewritable->EraseArea.Width,
					   pRewritable->EraseArea.Bottom,
					   pRewritable->EraseArea.Height);
	AddDriverMessage(_T("Erase Area") + sep + temp_string);

	AddDriverMessage(_T("Erase Before Print") + sep + Parent->OnOffString(pRewritable->EraseBeforePrint));

	temp_string.Format(_T("%d"), pRewritable->ErasePowerStart);
	AddDriverMessage(_T("Erase Power Start") + sep + temp_string);

	temp_string.Format(_T("%d"), pRewritable->ErasePowerEnd);
	AddDriverMessage(_T("Erase Power End") + sep + temp_string);

	temp_string.Format(_T("%d"), pRewritable->WritePower);
	AddDriverMessage(_T("Write Power") + sep + temp_string);

	AddDriverMessage(_T(""));
}

//****************************************************************************

void CDriverSettings1::SetRewritable(PREWRITABLE pRewritable)
{
	//Update the controls for the Rewritable Card settings
	CString temp_string;
	temp_string.Format(_T("%d"), pRewritable->EraseArea.Left);
	EraseArea_Left.SetWindowText(temp_string);
	temp_string.Format(_T("%d"), pRewritable->EraseArea.Width);
	EraseArea_Width.SetWindowText(temp_string);
	temp_string.Format(_T("%d"), pRewritable->EraseArea.Bottom);
	EraseArea_Bottom.SetWindowText(temp_string);
	temp_string.Format(_T("%d"), pRewritable->EraseArea.Height);
	EraseArea_Height.SetWindowText(temp_string);
	temp_string.Format(_T("%d"), pRewritable->ErasePowerStart);
	ErasePower_Start.SetWindowText(temp_string);
	temp_string.Format(_T("%d"), pRewritable->ErasePowerEnd);
	ErasePower_End.SetWindowText(temp_string);
	temp_string.Format(_T("%d"), pRewritable->WritePower);
	WritePower.SetWindowText(temp_string);
	EraseBeforePrint.SetCheck(pRewritable->EraseBeforePrint);
}

//****************************************************************************

ID_RETURN CDriverSettings1::GetRewritable
(
	PREWRITABLE pRewritable
)
{
	ID_RETURN SDKReturn = ID_ERROR;

	//Get SDK function address
	PFNIDREWRITABLE pFnRewritable = (PFNIDREWRITABLE)GetProcAddress(Parent->hLib, "ID_Rewritable");
	if (!pFnRewritable)
	{
		FUNCTION_NOT_ACCESSED(GetRewritable);
	}

	else
	{
		//Call SDK to read the Rewritable Card settings
		SDKReturn = (*pFnRewritable)(Parent->hSession, ID_READ, pRewritable);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(GetRewritable, SDKReturn);
		}
		else
		{
			SetRewritable(pRewritable);
		}
	}

	return SDKReturn;
}

//****************************************************************************

void CDriverSettings1::OnBnClickedBtnRewritable()
{
	REWRITABLE Rewritable = {};
	CWaitCursor wait;
	CString temp_string;

	if (ActionIsGet())
	{
		//Get Rewritable Settings
		if (GetRewritable(&Rewritable) == ID_SUCCESS)
		{
			RewritableToMsgBox(&Rewritable, ID_READ);
		}
	}

	else
	{
		//Get SDK function address
		PFNIDREWRITABLE pFnSetRewritable = (PFNIDREWRITABLE)GetProcAddress(Parent->hLib, "ID_Rewritable");
		if (!pFnSetRewritable)
		{
			FUNCTION_NOT_ACCESSED(SetRewritable);
		}

		else
		{
			//Get Rewritable settings from controls
			Rewritable.EraseBeforePrint = (EraseBeforePrint.GetCheck() == BST_CHECKED);
			EraseArea_Left.GetWindowText(temp_string);
			Rewritable.EraseArea.Left   = _ttoi(temp_string);
			EraseArea_Width.GetWindowText(temp_string);
			Rewritable.EraseArea.Width  = _ttoi(temp_string);
			EraseArea_Bottom.GetWindowText(temp_string);
			Rewritable.EraseArea.Bottom = _ttoi(temp_string);
			EraseArea_Height.GetWindowText(temp_string);
			Rewritable.EraseArea.Height = _ttoi(temp_string);
			ErasePower_Start.GetWindowText(temp_string);
			Rewritable.ErasePowerStart  = _ttoi(temp_string);
			ErasePower_End.GetWindowText(temp_string);
			Rewritable.ErasePowerEnd    = _ttoi(temp_string);
			WritePower.GetWindowText(temp_string);
			Rewritable.WritePower       = _ttoi(temp_string);

			//Call the SDK to write to the driver
			ID_RETURN SDKReturn = (*pFnSetRewritable)(Parent->hSession, ID_WRITE, &Rewritable);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(SetRewritable, SDKReturn);
			}

			else
			{
				//Update the message box
				RewritableToMsgBox(&Rewritable, ID_WRITE);
			}
		}
	}
}

//#############################################################################

void CDriverSettings1::PrintableAreaToMsgBox
(
	PAREA        pArea,
	ID_READWRITE Action
)
{
	//Update the message box with the Printable Area settings
	CString temp_string;
	CString sep = Parent->Separator(Action);

	AddDriverMessage(_T("Printable Area"));
	temp_string.Format(_T("%d"), pArea->Left);
	AddDriverMessage(_T("Left") + sep + temp_string);
	temp_string.Format(_T("%d"), pArea->Width);
	AddDriverMessage(_T("Width") + sep + temp_string);
	temp_string.Format(_T("%d"), pArea->Bottom);
	AddDriverMessage(_T("Bottom") + sep + temp_string);
	temp_string.Format(_T("%d"), pArea->Height);
	AddDriverMessage(_T("Height") + sep + temp_string);
	AddDriverMessage(_T(""));
}

//****************************************************************************

void CDriverSettings1::SetPrintableArea(PAREA pArea)
{
	//Update the Printable Area controls
	CString temp_string;
	temp_string.Format(_T("%d"), pArea->Left);
	PrintableArea_Left.SetWindowText(temp_string);
	temp_string.Format(_T("%d"), pArea->Width);
	PrintableArea_Width.SetWindowText(temp_string);
	temp_string.Format(_T("%d"), pArea->Bottom);
	PrintableArea_Bottom.SetWindowText(temp_string);
	temp_string.Format(_T("%d"), pArea->Height);
	PrintableArea_Height.SetWindowText(temp_string);
}

//****************************************************************************

ID_RETURN CDriverSettings1::GetPrintableArea
(
	PAREA	pArea
)
{
	ID_RETURN SDKReturn = ID_ERROR;

	//Get SDK function address
	PFNIDPRINTAREA pFnPrintableArea = (PFNIDPRINTAREA)GetProcAddress(Parent->hLib, "ID_PrintableArea");
	if (!pFnPrintableArea)
	{
		FUNCTION_NOT_ACCESSED(GetPrintableArea);
	}

	else
	{
		//Call SDK to read the Printable Area setting
		SDKReturn = (*pFnPrintableArea)(Parent->hSession, ID_READ, pArea);
		if (SDKReturn == ID_SUCCESS)
		{
			SetPrintableArea(pArea);
		}
		else
		{
			DISPLAY_ERROR(GetPrintableArea, SDKReturn);
		}
	}

	return SDKReturn;
}

//****************************************************************************

void CDriverSettings1::OnBnClickedPrintablearea()
{
	AREA Area = {0};
	CWaitCursor wait;
	CString temp_string;

	if (ActionIsGet())
	{
		//Get the Printable Area settings
		if (GetPrintableArea(&Area) == ID_SUCCESS)
		{
			//Update the display
			PrintableAreaToMsgBox(&Area, ID_READ);
		}
	}

	else
	{
		//Get SDK function address
		PFNIDPRINTAREA pFnSetPrintableArea = (PFNIDPRINTAREA)GetProcAddress(Parent->hLib, "ID_PrintableArea");
		if (!pFnSetPrintableArea)
		{
			FUNCTION_NOT_ACCESSED(SetPrintableArea);
		}

		else
		{
			//Get the selected Printable Area settings
			PrintableArea_Left.GetWindowText(temp_string);
			Area.Left = _ttoi(temp_string);
			PrintableArea_Width.GetWindowText(temp_string);
			Area.Width = _ttoi(temp_string);
			PrintableArea_Bottom.GetWindowText(temp_string);
			Area.Bottom = _ttoi(temp_string);
			PrintableArea_Height.GetWindowText(temp_string);
			Area.Height = _ttoi(temp_string);

			//Call the SDK to write to the driver
			ID_RETURN SDKReturn = (*pFnSetPrintableArea)(Parent->hSession,
											             ID_WRITE,
											             &Area);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(SetPrintableArea, SDKReturn);
			}

			else
			{
				//Update the message box
				PrintableAreaToMsgBox(&Area, ID_WRITE);
			}
		}
	}
}

//#############################################################################

void CDriverSettings1::ResolutionToMsgBox
(
	BYTE         Value,
	ID_READWRITE Action
)
{
	//Update the message box with the DPI settings
	CString temp_string = _T("Resolution");
	temp_string += Parent->Separator(Action);
	switch (Value)
	{
	case 0: temp_string += "300"; break;
	case 1: temp_string += "600"; break;
	default:
		DISPLAY_ERROR(ResolutionToMsgBox, 0);
		return;
	}
	temp_string += " x 300 DPI";
	AddDriverMessage(temp_string);
	AddDriverMessage(_T(""));
}

//****************************************************************************

void CDriverSettings1::SetResolutionRadio
(
	BYTE Value
)
{
	//Update the DPI controls
	switch (Value)
	{
	case 0: ResolutionRadio = 0; break;
	case 1: ResolutionRadio = 1; break;
	default:
		DISPLAY_ERROR(SetResolution, 0);
		return;
	}
	UpdateData(FALSE);
}

//****************************************************************************

ID_RETURN CDriverSettings1::GetResolution
(
	LPBYTE Value
)
{
	ID_RETURN SDKReturn = ID_ERROR;

	//Get SDK function address
	PFNIDRESOLUTION pFnResolution = (PFNIDRESOLUTION)GetProcAddress(Parent->hLib, "ID_Resolution");
	if (!pFnResolution)
	{
		FUNCTION_NOT_ACCESSED(GetResolution);
	}

	else
	{
		//Call SDK to read the DPI setting
		SDKReturn = (*pFnResolution)(Parent->hSession, ID_READ, Value);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(GetResolution, SDKReturn);
		}
		else
		{
			SetResolutionRadio(*Value);
		}
	}

	return SDKReturn;
}

//****************************************************************************

void CDriverSettings1::OnBnClickedBtnResolution()
{
	BYTE Resolution;

	if (ActionIsGet())
	{
		if (GetResolution(&Resolution) == ID_SUCCESS)
		{
			ResolutionToMsgBox(Resolution, ID_READ);
		}
	}

	else
	{
		PFNIDRESOLUTION pFnResolution = (PFNIDRESOLUTION)GetProcAddress(Parent->hLib, "ID_Resolution");
		if (!pFnResolution)
		{
			FUNCTION_NOT_ACCESSED(SetResolution);
		}

		else
		{
			BYTE Resolution = GetResolutionRadio();
			ID_RETURN SDKReturn = (*pFnResolution)(Parent->hSession, ID_WRITE, &Resolution);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(SetResolution, SDKReturn);
			}

			else
			{
				ResolutionToMsgBox(Resolution, ID_WRITE);
			}
		}
	}
}
